<?php
/*--------------------------------------------------------------
   Reader.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Data;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\WidgetDefinitions;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDefinition;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Id;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Type;

class Reader
{
    /**
     * @var Database
     */
    private $database;
    
    /**
     * @var Collector
     */
    private $collector;
    
    
    /**
     * Constructor.
     */
    public function __construct(Database $database, Collector $collector)
    {
        $this->database  = $database;
        $this->collector = $collector;
    }
    
    
    /**
     * Return widget database entries.
     */
    public function getWidgetDatabaseEntries(): array
    {
        return $this->database->findAll();
    }
    
    
    /**
     * Return widget database entry by ID.
     */
    public function getWidgetDatabaseEntryById(Id $id): array
    {
        return $this->database->findById($id->value());
    }
    
    
    /**
     * Return widget definition by type.
     */
    public function getWidgetDefinitionByType(Type $type): WidgetDefinition
    {
        return $this->collector->getWidgetDefinitionByType($type);
    }
    
    
    /**
     * Return widget definitions.
     */
    public function getWidgetDefinitions(): WidgetDefinitions
    {
        return $this->collector->getWidgetDefinitions();
    }
}